Attribute VB_Name = "mdRotateAxes"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.



Function RotateAxes(angle As Double)

'Conveninece Function to rotate the axes through a specified angle in degrees

'Get the ProDESKTOP Application object
GetApplicationObject

'Get the active Partdocument,Workplane
Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim workplane As aWorkplane
Set workplane = Part.GetActiveWorkplane

'Get the existing origin
Dim origin As zVector
Dim localX  As zDirection
Dim localY As zDirection
Set origin = workplane.GetLocalOrigin()
Set localX = workplane.GetLocalX()
Set localY = workplane.GetLocalY()

'Convert the angle from degrees to radians
Dim radianAngle
radianAngle = (3.142857142857 * angle) / 180

Dim cosine As Double
Dim sine As Double
cosine = Cos(radianAngle)
sine = Sin(radianAngle)

Dim newX As zVector
Dim newY As zVector

Set newX = localX.Multiply(cosine).Add(localY.Multiply(sine))
Set newY = localX.Multiply(-sine).Add(localY.Multiply(cosine))

'Gets the transformation matrix
Dim oldMapping As zMatrix
Dim newMapping As zMatrix
Dim transMatrix As zMatrix

Set oldMapping = app.GetClass("Matrix").CreateTranslationMatrix(origin).MultiplyByMatrix(app.GetClass("Matrix").CreateRotationMatrix(localX, localY))
Set newMapping = app.GetClass("Matrix").CreateTranslationMatrix(origin).MultiplyByMatrix(app.GetClass("Matrix").CreateRotationMatrix(newX.GetDirection, newY.GetDirection))
Set transMatrix = newMapping.MultiplyByMatrix(oldMapping.GetInverse())

workplane.SetLocalOrigin transMatrix.MultiplyByVector(workplane.GetLocalOrigin)
workplane.SetLocalAxes transMatrix.MultiplyByDirection(workplane.GetLocalX), transMatrix.MultiplyByDirection(workplane.GetLocalY)

End Function





